/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.loot;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.loot.LootTableEntry;
import com.github.d0ctorleon.mythsandlegends.loot.LootTableItemConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_7923;

public class LootTableModifier {
    private static final Gson GSON = new GsonBuilder().create();
    private static final List<class_2960> DEFAULT_LOOT_TABLES = Arrays.asList(class_2960.method_60654((String)"minecraft:chests/abandoned_mineshaft"), class_2960.method_60654((String)"minecraft:chests/ancient_city"), class_2960.method_60654((String)"minecraft:chests/bastion_treasure"), class_2960.method_60654((String)"minecraft:chests/buried_treasure"), class_2960.method_60654((String)"minecraft:chests/desert_pyramid"), class_2960.method_60654((String)"minecraft:chests/end_city_treasure"), class_2960.method_60654((String)"minecraft:chests/jungle_temple"), class_2960.method_60654((String)"minecraft:chests/shipwreck_treasure"), class_2960.method_60654((String)"minecraft:chests/woodland_mansion"), class_2960.method_60654((String)"minecraft:gameplay/fishing/treasure"), class_2960.method_60654((String)"minecraft:gameplay/sniffer_digging"), class_2960.method_60654((String)"minecraft:archaeology/trail_ruins_rare"));
    private static List<LootTableItemConfig> lootTableConfig;

    public static void registerLootModifications() {
        LootTableModifier.loadLootTableConfig();
        if (lootTableConfig == null) {
            return;
        }
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            for (LootTableItemConfig itemConfig : lootTableConfig) {
                if (!itemConfig.enabled) continue;
                for (LootTableEntry entry : itemConfig.lootTables) {
                    if (!builtin || !entry.id.equals((Object)key.method_29177())) continue;
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemConfig.itemId));
                    class_55.class_56 poolBuilder = class_55.method_347().method_351(class_77.method_411((class_1935)item).method_421(class_219.method_932((float)entry.weight)));
                    context.addPool(poolBuilder);
                }
            }
        });
    }

    public static void loadLootTableConfig() {
        File configFile = Platform.getConfigFolder().resolve("MythsAndLegends").resolve("loot_tables_config.json").toFile();
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonArray itemsArray = json.getAsJsonArray("items");
            lootTableConfig = new ArrayList<LootTableItemConfig>();
            for (JsonElement itemElement : itemsArray) {
                JsonObject itemObject = itemElement.getAsJsonObject();
                LootTableItemConfig itemConfig = new LootTableItemConfig();
                itemConfig.itemId = itemObject.get("itemId").getAsString();
                itemConfig.enabled = itemObject.get("enabled").getAsBoolean();
                JsonArray lootTablesArray = itemObject.getAsJsonArray("lootTables");
                for (JsonElement lootTableElement : lootTablesArray) {
                    JsonObject lootTableObject = lootTableElement.getAsJsonObject();
                    String lootTableId = lootTableObject.get("id").getAsString();
                    float weight = lootTableObject.get("weight").getAsFloat();
                    LootTableEntry entry = new LootTableEntry(lootTableId, weight);
                    itemConfig.lootTables.add(entry);
                }
                lootTableConfig.add(itemConfig);
            }
        }
        catch (FileNotFoundException e) {
            MythsAndLegends.getLogger().info("Configuration file not found, creating default configuration file.");
            LootTableModifier.createDefaultConfigFile();
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Error loading configuration file: {}", (Object)e.getMessage());
        }
    }

    private static void createDefaultConfigFile() {
        lootTableConfig = new ArrayList<LootTableItemConfig>();
        for (class_2960 identifier : Items.MYTHS_AND_LEGENDS_ITEMS) {
            MythsAndLegends.getLogger().info("Adding item: " + String.valueOf(identifier));
            LootTableItemConfig itemConfig = new LootTableItemConfig();
            itemConfig.itemId = identifier.toString();
            itemConfig.enabled = true;
            for (class_2960 lootTableId : DEFAULT_LOOT_TABLES) {
                LootTableEntry entry = new LootTableEntry(lootTableId.toString(), 0.005f);
                itemConfig.lootTables.add(entry);
            }
            lootTableConfig.add(itemConfig);
        }
        LootTableModifier.saveConfigToFile();
    }

    private static void saveConfigToFile() {
        File configFile = Platform.getConfigFolder().resolve("MythsAndLegends").resolve("loot_tables_config.json").toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject json = new JsonObject();
            JsonArray itemsArray = new JsonArray();
            for (LootTableItemConfig itemConfig : lootTableConfig) {
                JsonObject itemObject = new JsonObject();
                itemObject.addProperty("itemId", itemConfig.itemId);
                itemObject.addProperty("enabled", Boolean.valueOf(itemConfig.enabled));
                JsonArray lootTablesArray = new JsonArray();
                for (LootTableEntry entry : itemConfig.lootTables) {
                    JsonObject entryObject = new JsonObject();
                    entryObject.addProperty("id", entry.id.toString());
                    entryObject.addProperty("weight", (Number)Float.valueOf(entry.weight));
                    lootTablesArray.add((JsonElement)entryObject);
                }
                itemObject.add("lootTables", (JsonElement)lootTablesArray);
                itemsArray.add((JsonElement)itemObject);
            }
            json.add("items", (JsonElement)itemsArray);
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Error saving configuration file: " + e.getMessage());
        }
    }
}

